#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <wiringPi.h>

#define TYPE_GET_NOPL 1
#define TYPE_GET_ENRUN 2
#define SHUTDOWN_COMMAND "/bin/sh /usr/local/sbin/fastshutdown"
#define CONFIG_FILE "/usr/local/sbin/shutdownSensor.conf"

int enrunPin = 18;
int noplPin = 23;
static volatile int currentValue = 0;

void loadConfigFile() {
	FILE *fp;
	if((fp=fopen(CONFIG_FILE,"r"))!=NULL) {
		char buf[128];
		while( fgets(buf, sizeof(buf), fp) != NULL ) {
			int len = strlen(buf);
			if (len == 0 || buf[0] == '\n' || buf[0] == '#') {
				continue;
			}
			int value = 0;
			sscanf(buf,"enrun pin = %d", &value);
			if (1 <= value) {
				enrunPin = value;
			}
			sscanf(buf,"nopl pin = %d", &value);
			if (1 <= value) {
				noplPin = value;
			}
		}
		fclose(fp);
	}
	printf("enrunPin: %d, noplPin: %d\n", enrunPin, noplPin);
}

void pressShutdownButton() {
	system(SHUTDOWN_COMMAND);
}

int main(int argc, char *argv[]) {
	if (wiringPiSetupGpio() == -1) {
		return 1;
	}
	loadConfigFile();
	if (2 <= argc) {
		int type = atoi(argv[1]);
		if (type == TYPE_GET_NOPL) {
			pinMode(noplPin, INPUT);
			pullUpDnControl(noplPin, PUD_UP);
			int sw = digitalRead(noplPin);
			return sw;
		}
		if (type == TYPE_GET_ENRUN) {
			pinMode(enrunPin, OUTPUT);
			digitalWrite(enrunPin, 0);
			return 0;
		}
		return 0;
	}
	pinMode(enrunPin, OUTPUT);
	digitalWrite(enrunPin, 1);
	pinMode(noplPin, INPUT);
	pullUpDnControl(noplPin, PUD_UP);
	wiringPiISR(noplPin, INT_EDGE_FALLING, &pressShutdownButton);
	while (1) {
		sleep(60);
	}
	return 0;
}

